// snackbar-widget.js  — host di CDN kamu
(function () {
  // --- Ambil config dari <script data-*> ---
  const me = document.currentScript;
  const cfg = {
    icon:      me.dataset.icon || "https://dllbwy.com/favicon.webp",
    bg:        me.dataset.bg || "#0f1d86",
    text:      me.dataset.text || "#ffffff",
    top:       parseInt(me.dataset.top || "40", 10),
    left:      me.dataset.left !== undefined ? parseInt(me.dataset.left, 10) : null,
    right:     me.dataset.right !== undefined ? parseInt(me.dataset.right, 10) : null,
    maxwidth:  parseInt(me.dataset.maxwidth || "260", 10),
    showMs:    parseInt(me.dataset.showms || "3800", 10),
    gapMin:    parseInt(me.dataset.gapmin || "3000", 10),
    gapMax:    parseInt(me.dataset.gapmax || "9000", 10),
  };

  // --- Util ---
  function rand(min, max){ return Math.floor(Math.random()*(max-min+1))+min; }
  function pick(arr){ return arr[Math.floor(Math.random()*arr.length)]; }

  // Nama random + masking
  const sampleNames = ["andi","budi","candra","dewi","eka","farah","gilang","hani","irfan","joko","kiki","lina","miko","nanda","ony","putri","qori","raka","sari","tio","udin","vivi","winda","yudi","zaki"];
  function maskName(raw){
    raw = String(raw||"user").trim();
    const headLen = raw.length>2 ? rand(1,2) : 1;
    const tailLen = raw.length>3 ? rand(1,2) : 1;
    return raw.slice(0, headLen) + "***" + raw.slice(-tailLen);
  }
  // Format Rupiah
  const rupiahFmt = new Intl.NumberFormat("id-ID", {style:"currency", currency:"IDR", minimumFractionDigits:2});
  function randomAmount(min=250000, max=8500000){
    const amt = Math.round(rand(min, max)/1000)*1000;
    return rupiahFmt.format(amt).replace(/\s/g, "\u00A0");
  }

  // --- Buat ID unik supaya gak bentrok ---
  const uid = "snack_" + Math.random().toString(36).slice(2,9);

  // --- Sisipkan STYLE namespaced ---
  const css = `
#${uid}{
  position: fixed;
  top: ${cfg.top}px;
  ${cfg.left !== null ? `left:${cfg.left}px;` : ""}
  ${cfg.right !== null ? `right:${cfg.right}px;` : ""}
  z-index: 100000;

  display: flex;
  align-items: center;
  gap: 10px;

  width: auto;
  max-width: ${cfg.maxwidth}px;
  padding: 10px 12px;
  border-radius: 15px;
  box-sizing: border-box;

  background: ${cfg.bg};
  color: ${cfg.text};
  font-weight: 700;
  font-size: 13px;
  line-height: 1.3;
  outline: 1px solid #fff;
  box-shadow: 0 10px 25px rgba(0,0,0,.25);

  visibility: hidden;
  opacity: 0;
  transform: translateY(-12px);
  transition: opacity .25s ease, transform .25s ease, visibility .25s linear;

  pointer-events: none;
  text-align: left;
}
#${uid}.show { visibility: visible; opacity:1; transform:translateY(0); }
#${uid} .icon{ width:35px; height:35px; border-radius:50%; overflow:hidden; flex:0 0 35px; }
#${uid} .icon img{ width:35px; height:35px; display:block; }
#${uid} .txt{ margin:0; }
@media (max-width:360px){ #${uid}{ max-width:${Math.max(200, cfg.maxwidth-30)}px; font-size:12px; } }
  `.trim();
  const styleEl = document.createElement("style");
  styleEl.textContent = css;
  document.head.appendChild(styleEl);

  // --- Buat container ---
  const box = document.createElement("div");
  box.id = uid;
  box.setAttribute("role","status");
  box.setAttribute("aria-live","polite");
  box.innerHTML = `
    <span class="icon"><img src="${cfg.icon}" alt="icon"></span>
    <p class="txt"></p>
  `;
  document.body.appendChild(box);
  const txtEl = box.querySelector(".txt");

  function cycleOnce(){
    const name = maskName(pick(sampleNames));
    const amount = randomAmount();
    txtEl.innerHTML = `${name} Berhasil Withdraw<br>${amount}`;
    box.classList.add("show");
    setTimeout(() => {
      box.classList.remove("show");
      setTimeout(cycleOnce, rand(cfg.gapMin, cfg.gapMax));
    }, cfg.showMs);
  }

  if (document.readyState === "complete" || document.readyState === "interactive"){
    setTimeout(cycleOnce, 1000);
  } else {
    window.addEventListener("load", () => setTimeout(cycleOnce, 1000));
  }
})();
